// PeopleCounterDemo.cpp: Demo example
//
#include <opencv/cv.h>
#include <opencv/cvaux.h>
#include <opencv/cxcore.h>
#include <opencv/highgui.h>

#include <iostream>
#include <sstream>
#include <iomanip>
#include <fstream>
#include <string>

using namespace cv;
using namespace std;

//ViolaJones detector interface
#include "ViolaJonesDetectorInterface.h"

//Main function processing webcam
void LaunchDetection(string classifier, int stages)
{ 
    //Text setup
    char text[128];
    int fontFace = FONT_HERSHEY_SCRIPT_SIMPLEX;
    double fontScale = 0.7;
    int thickness = 1;

    //Camera activation
	VideoCapture capture;
	Mat frame;
	capture.open(0); //Camera
	 
   if( capture.isOpened() )
    {
        //Detector load
		CViolaDetector *VJDet=new CViolaDetector((char *)classifier.c_str(),true);
	
		//Configure the nuber of detector stages, a negative number is expected
		if (stages<0 && VJDet->cascade->count+stages>0)//If not default count is used
			VJDet->cascade->count=VJDet->cascade->count+stages;
	
		//Colos definition
		CvScalar color;
		color=cvScalar(0,255,0);	
	
        for(;;)
        {
            capture >> frame; 
			IplImage img=frame;

			int scale=1;
	    
			//Locating objects
			long tini=clock();
			VJDet->ProcessImage(&img,scale);
			float fps=(float)(CLOCKS_PER_SEC)/(float)(clock()-tini);
	    
			//Painting containers
			for (int i=0;i<VJDet->NumObjects;i++)
			{
				VJDet->PintaDetecciones(&img,color,i);
			}	
	    
			cout << fps << " fps" << endl;
	    
			//Message
			sprintf(text,"%s %d stages",(char *)classifier.c_str(),VJDet->cascade->count);	   
			putText(frame, text, Point(10,25), fontFace, fontScale, Scalar::all(255), thickness, 8);
			sprintf(text,"%.1f fps",fps);	   
			putText(frame, text, Point(10,50), fontFace, fontScale, Scalar::all(255), thickness, 8);
	    
			imshow("Objects",frame);
			int c = cvWaitKey( 5 );
		
			if( c == 27 )
				break;
		}
	
	//Deallocating
	delete VJDet;	
	capture.release();
    }
}


void help()
{
  // print help message
  cout << "DetectorVJ  <classifier.xml> <nstages>" << endl;
}

int main(int argc,char* argv[])
{
    string classifier;
   
    //Input arguments check  
    if (argc < 3)
    {
	  help();
    }
    else 
    {
      classifier.assign(argv[1]);
      
      LaunchDetection(classifier,atoi(argv[2]));
    }
  
    return 0;
}
